#!/usr/bin/env bash
# Default Backtrack 5 OWTF location, change this to wherever you have it if it is somewhere else
OWTF_DIR="/pentest/exploits/owtf/"
export PATH="$PATH:$OWTF_DIR"

clear
echo "DEMO 0: Simulation Mode"
echo "# owtf.py -s https://accounts.google.com | more"
read a
rm -rf owtf_review ; owtf.py -s https://accounts.google.com | more
echo "Enter to continue"
read a

clear
echo "DEMO 1: Single Plugin Run"
echo "# owtf.py -t passive -o Spiders_Robots_and_Crawlers https://accounts.google.com"
read a
rm -rf owtf_review ; owtf.py -t passive -o Spiders_Robots_and_Crawlers https://accounts.google.com
echo "Enter to continue"
read a

clear
echo "DEMO 2: Multiple Plugin Run"
echo "# owtf.py -t passive https://accounts.google.com"
read a
owtf.py -t passive https://accounts.google.com
echo "Enter to continue"
read a

clear
echo "DEMO 3: Multiple Plugin Run with Exclusion"
echo "# owtf.py -t semi_passive -e Search_engine_discovery_reconnaissance https://accounts.google.com"
read a
owtf.py -t semi_passive -e Search_engine_discovery_reconnaissance https://accounts.google.com
echo "Enter to continue"
read a

clear
echo "DEMO 4: Multiple Plugin Run with multiple exclusion against multiple targets"
echo "# owtf.py -t quiet -e Search_engine_discovery_reconnaissance,Testing_for_SSL-TLS http://hackademic1.teilar.gr/ http://demo.testfire.net/ http://testasp.acunetix.com/"
read a
owtf.py -t quiet -e Search_engine_discovery_reconnaissance,Testing_for_SSL-TLS http://hackademic1.teilar.gr/ http://demo.testfire.net/ http://testasp.acunetix.com/
echo "Enter to continue"
read a

clear
echo "DEMO 5: Run all plugins not yet run, including active plugins"
echo "# owtf.py http://hackademic1.teilar.gr/ http://demo.testfire.net/ http://testasp.acunetix.com/"
read a
owtf.py http://hackademic1.teilar.gr/ http://demo.testfire.net/ http://testasp.acunetix.com/
echo "Enter to continue"
read a
